/*
 * Decompiled with CFR 0.152.
 */
package reliquary.crafting.alkahestry;

import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.crafting.ConditionalRecipe;
import net.minecraftforge.common.crafting.conditions.ICondition;
import reliquary.crafting.AlkahestryCraftingRecipe;
import reliquary.crafting.conditions.AlkahestryEnabledCondition;

public class CraftingRecipeBuilder {
    private final Ingredient item;
    private final int charge;
    private final int resultCount;
    private final List<ICondition> additionalConditions = new ArrayList<ICondition>();

    private CraftingRecipeBuilder(Ingredient item, int charge, int resultCount) {
        this.item = item;
        this.charge = charge;
        this.resultCount = resultCount;
    }

    public static CraftingRecipeBuilder craftingRecipe(ItemLike item, int charge, int resultCount) {
        return new CraftingRecipeBuilder(Ingredient.m_43929_((ItemLike[])new ItemLike[]{item}), charge, resultCount);
    }

    public static CraftingRecipeBuilder craftingRecipe(TagKey<Item> tag, int charge, int resultCount) {
        return new CraftingRecipeBuilder(Ingredient.m_204132_(tag), charge, resultCount);
    }

    public CraftingRecipeBuilder addCondition(ICondition condition) {
        this.additionalConditions.add(condition);
        return this;
    }

    public void build(Consumer<FinishedRecipe> consumer, ResourceLocation id) {
        ResourceLocation fullId = new ResourceLocation("reliquary", "alkahestry/crafting/" + id.m_135815_());
        ConditionalRecipe.Builder builder = ConditionalRecipe.builder().addCondition((ICondition)new AlkahestryEnabledCondition());
        this.additionalConditions.forEach(arg_0 -> ((ConditionalRecipe.Builder)builder).addCondition(arg_0));
        builder.addRecipe(conditionalConsumer -> conditionalConsumer.accept(new Result(fullId, this.item, this.charge, this.resultCount)));
        builder.build(consumer, fullId);
    }

    public static class Result
    implements FinishedRecipe {
        private final Ingredient item;
        private final int charge;
        private final int resultCount;
        private final ResourceLocation id;

        public Result(ResourceLocation id, Ingredient item, int charge, int resultCount) {
            this.id = id;
            this.item = item;
            this.charge = charge;
            this.resultCount = resultCount;
        }

        public void m_7917_(JsonObject json) {
            json.addProperty("charge", (Number)this.charge);
            json.add("ingredient", this.item.m_43942_());
            json.addProperty("result_count", (Number)this.resultCount);
        }

        public ResourceLocation m_6445_() {
            return this.id;
        }

        public RecipeSerializer<?> m_6637_() {
            return AlkahestryCraftingRecipe.SERIALIZER;
        }

        @Nullable
        public JsonObject m_5860_() {
            return null;
        }

        @Nullable
        public ResourceLocation m_6448_() {
            return null;
        }
    }
}

